const { BrowserWindow } = require('electron');

const logger = require('../Logger').Logger;
const Headset = require('./headset');
const { EVENTS, HEADSET_STATUS } = require('./consts');

class HeadsetSingleton {
    static headsetSingleton = null;

    constructor() {
        this.win = null;
        this.headset = null;
        this.headset = new Headset((connectionMode, isDfu, isOld, progress) =>
            this.pushConnectionNotification(
                connectionMode,
                isDfu,
                isOld,
                progress
            )
        );
    }

    pushConnectionNotification(connectionMode, isDfu, isOld, progress) {
        setTimeout(() => {
            // anytime it changes we need to update
            this.win = this.win || BrowserWindow.getFocusedWindow();

            if (this.win === null || this.win.webContents === null) {
                logger.info(
                    'HeadsetSingleton: pushConnectionNotification: not ready:',
                    this.win === null
                );
                return;
            }

            let details = {
                connected: connectionMode,
                isDfu,
                isOld,
                progress
            };

            if (
                connectionMode === HEADSET_STATUS.HEADSET_CONNECTED &&
                !this.headset.flashing_fw
            ) {
                logger.info(
                    'HeadsetSingleton: pushConnectionNotification -  calling getHardwareModel',
                    this.headset.isDfu()
                );
                details = Object.assign(
                    details,
                    this.headset.getHardwareModel()
                );
                if (!details) return;
            }

            logger.info(
                'HeadsetSingleton: pushConnectionNotification -  sending IS_DEVICE_CONNECTED-push',
                details
            );
            this.win.webContents.send(
                `${EVENTS.IS_DEVICE_CONNECTED}-push`,
                details
            );
        }, 500);
    }

    static getInstance() {
        if (!HeadsetSingleton.headsetSingleton) {
            HeadsetSingleton.headsetSingleton = new HeadsetSingleton();
        }
        return HeadsetSingleton.headsetSingleton.headset;
    }
}

export function getInstance() {
    return HeadsetSingleton.getInstance();
}
